<!doctype html>
<html <?php language_attributes(); ?> class="no-js">

<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<title><?php echo is_archive('para-seu-negocio') ? yoastVariableToTitle(12) : wp_title(); ?></title>

	<link href="//www.google-analytics.com" rel="dns-prefetch">
	<link href="<?php echo esc_url(get_template_directory_uri()); ?>/img/icons/favicon.svg" rel="shortcut icon">
	<link href="<?php echo esc_url(get_template_directory_uri()); ?>/img/icons/touch.png" rel="apple-touch-icon-precomposed">
	<link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?>" href="<?php bloginfo('rss2_url'); ?>" />

	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="description" content="<?php echo get_post_meta(is_archive('para-seu-negocio') ? 12 : get_the_ID(), '_yoast_wpseo_metadesc', true); ?>">

	<?php wp_head(); ?>
	<!-- analytics -->
	<!-- Google Tag Manager -->
	<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
	new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
	j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
	'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
	})(window,document,'script','dataLayer','GTM-TG6W4JG');</script>
	<!-- End Google Tag Manager -->
	<style>
		.grecaptcha-badge { display: none; }
	</style>
</head>

<body <?php body_class(); ?>>
	<?php if (!isset($_COOKIE['modal_close'])) { ?>
		<div id="singNowModal">
			<button class="close"><svg width="11" height="11" viewBox="0 0 11 11" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path d="M6.51429 5.21359L10.155 1.57286C10.3278 1.40037 10.425 1.16632 10.4252 0.922172C10.4254 0.678028 10.3286 0.443798 10.1562 0.27101C9.98368 0.0982212 9.74962 0.00102873 9.50548 0.000813122C9.26134 0.000597511 9.02711 0.0973765 8.85432 0.26986L5.21359 3.91059L1.57286 0.26986C1.40007 0.0970716 1.16572 0 0.921359 0C0.676999 0 0.442648 0.0970716 0.26986 0.26986C0.0970716 0.442648 0 0.676999 0 0.921359C0 1.16572 0.0970716 1.40007 0.26986 1.57286L3.91059 5.21359L0.26986 8.85432C0.0970716 9.02711 0 9.26146 0 9.50582C0 9.75018 0.0970716 9.98453 0.26986 10.1573C0.442648 10.3301 0.676999 10.4272 0.921359 10.4272C1.16572 10.4272 1.40007 10.3301 1.57286 10.1573L5.21359 6.51659L8.85432 10.1573C9.02711 10.3301 9.26146 10.4272 9.50582 10.4272C9.75018 10.4272 9.98453 10.3301 10.1573 10.1573C10.3301 9.98453 10.4272 9.75018 10.4272 9.50582C10.4272 9.26146 10.3301 9.02711 10.1573 8.85432L6.51429 5.21359Z" fill="white" />
				</svg></button>
			<h2>Experimente<br><span>DFLIX JÁ!</span></h2>
			<a href="https://cursos.dflix.com.br/" target="_blank" class="btn-transparent">Assine agora!</a>
		</div>

		<div class="modal fade" id="dflixModal" tabindex="-1" aria-labelledby="dflixModalLabel" aria-hidden="true">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-body">
						<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><svg width="11" height="11" viewBox="0 0 11 11" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path d="M6.51429 5.21359L10.155 1.57286C10.3278 1.40037 10.425 1.16632 10.4252 0.922172C10.4254 0.678028 10.3286 0.443798 10.1562 0.27101C9.98368 0.0982212 9.74962 0.00102873 9.50548 0.000813122C9.26134 0.000597511 9.02711 0.0973765 8.85432 0.26986L5.21359 3.91059L1.57286 0.26986C1.40007 0.0970716 1.16572 0 0.921359 0C0.676999 0 0.442648 0.0970716 0.26986 0.26986C0.0970716 0.442648 0 0.676999 0 0.921359C0 1.16572 0.0970716 1.40007 0.26986 1.57286L3.91059 5.21359L0.26986 8.85432C0.0970716 9.02711 0 9.26146 0 9.50582C0 9.75018 0.0970716 9.98453 0.26986 10.1573C0.442648 10.3301 0.676999 10.4272 0.921359 10.4272C1.16572 10.4272 1.40007 10.3301 1.57286 10.1573L5.21359 6.51659L8.85432 10.1573C9.02711 10.3301 9.26146 10.4272 9.50582 10.4272C9.75018 10.4272 9.98453 10.3301 10.1573 10.1573C10.3301 9.98453 10.4272 9.75018 10.4272 9.50582C10.4272 9.26146 10.3301 9.02711 10.1573 8.85432L6.51429 5.21359Z" fill="white" />
				</svg></button>
						<p>Esqueça as dívidase realize seus sonhos</p>
						<h2>Assine Dflix</h2>
						<h3>Assine por apenas</h3>
						<h4>R$9,90/mês</h4>
						<?= do_shortcode('[contact-form-7 id="239" title="Assinatura"]') ?>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>

	<?php if(!is_front_page()) { ?>
		<header>
		<div class="container">
			<div class="row">
				<div class="col col-lg-1 logo">
					<a href="<?= home_url(); ?>"><img src="<?= get_template_directory_uri(); ?>/img/icons/logo.svg" alt="Logo"></a>
				</div>
				<nav class="col d-lg-block d-none">
					<?= wp_nav_menu([
						'menu' => 'header',
						'link_after' => '<i class="fa-solid fa-chevron-down"></i>'
					]) ?>
				</nav>
				<div class="col-3 ml-auto d-xl-flex d-none links">
					<a href="https://cursos.dflix.com.br/" class="btn-orange" target="_blank">ASSINE AGORA</a>
					<a href="https://cursos.dflix.com.br/" class="btn-transparent" target="_blank">ENTRAR</a>
				</div>
				<div class="col-2 ml-auto d-block d-lg-none">
					<button class="btn-open">
						<img src="<?= get_template_directory_uri() ?>/img/icons/toggle-menu.svg" alt="">
					</button>
				</div>
				<div class="menu-mobile">
					<div class="header-menu">
						<a href="<?= home_url(); ?>"><img src="<?= get_template_directory_uri(); ?>/img/icons/logo.svg" alt="Logo"></a>
						<button class="close-menu">
							<img src="<?= get_template_directory_uri() ?>/img/icons/close-menu.svg" alt="fechar menu">
						</button>
					</div>
					<hr>
					<?= wp_nav_menu([
						'menu' => 'header',
						'link_after' => '<i class="fa-solid fa-chevron-down"></i>'
					]) ?>
				</div>
			</div>
		</div>
	</header>
	<?php } else { ?>
		<header class="light-theme">
		<div class="container">
			<div class="row">
				<div class="col col-lg-1 logo">
					<a href="<?= home_url(); ?>"><img src="<?= get_template_directory_uri() ?>/img/icons/logo.svg" alt="Logo"></a>
				</div>
				<nav class="col d-lg-block d-none">
					<?= wp_nav_menu([
						'menu' => 'header',
						'link_after' => '<i class="fa-solid fa-chevron-down"></i>'
					]) ?>
				</nav>
				<div class="ml-auto d-xl-flex d-none links" style="width: 150px;">
					<a href="https://cursos.dflix.com.br/" class="btn-orange" target="_blank">ASSINE AGORA</a>
					<a href="https://cursos.dflix.com.br/" class="btn-transparent" target="_blank">ENTRAR</a>
				</div>
				<div class="col-2 ml-auto d-block d-lg-none">
					<button class="btn-open">
						<img src="<?= get_template_directory_uri() ?>/img/icons/toggle-menu.svg" alt="">
					</button>
				</div>
				<div class="menu-mobile">
					<div class="header-menu">
						<a href="<?= home_url(); ?>"><img src="<?= get_template_directory_uri(); ?>/img/icons/logo.svg" alt="Logo"></a>
						<button class="close-menu">
							<img src="<?= get_template_directory_uri() ?>/img/icons/close-menu.svg" alt="fechar menu">
						</button>
					</div>
					<hr>
					<?= wp_nav_menu([
						'menu' => 'header',
						'link_after' => '<i class="fa-solid fa-chevron-down"></i>'
					]) ?>
				</div>
			</div>
		</div>
	</header>
	<?php } ?>